/*Symbol checking (kontrola symbolu) modul pro Universal Script Language*/
#include "tree.h"

#define HashTableSize 512	//velikost hash tabulky

//****************************************************************************************************************
//Hashovaci tabulka symbolu
//****************************************************************************************************************
class CHashedSymbolTable
{
private:
	SYMBOL**						m_Table;			//tabulka,tvorena polem ukazatelu na symboly
	int								m_TableSize;		//velikost tabulky
	CHashedSymbolTable*				m_ParentTable;		//ukazatel na rodicovskou tabulku
private:
	unsigned int					GetHash(char* str);			//vrati hash cislo odpovidajici zadanemu retezci
	SYMBOL*							Put(char* key,SymbolKind kind);	//vloz symbol do tabulky
public:
	HRESULT							Init(int size = HashTableSize);	//inicializace tabulky
	SYMBOL*							Get(char* key);					//pokud je nejaky szmbol definovan v tehle nebo nejake rodicovske tabulce, vrati na nej ukazatel
	SYMBOL*							PutVariable(char* variable);	//vlozi symbol promenne do tabulky
	SYMBOL*							PutFunction(char* function);	//vlozi symbol fce do tabulky
	bool							Defined(char* name);			//zjisti zda je symbol definovan v teto tabulce, rodicovske uz neprohledava	
	CHashedSymbolTable*				Scope();						//vytvori novou hashovaci tabulku a jeji ukazatel na rodicovskou tabulku nastavi na sebe
	void							Parent(CHashedSymbolTable* pTable)			{m_ParentTable = pTable;}	//nastavi ukazatel na rodicovskou tabulku
	CHashedSymbolTable*				Parent()									{return m_ParentTable;}		//vrati ukazatel na rodicovskou tabulku

	CHashedSymbolTable();		//konstruktor
	~CHashedSymbolTable();		//destruktor
};

/****************************************************************************************************************
Trida zapouzdrujici kontrolu symbolu pro nas skriptovaci jazyk

Diky produkcnim pravidlum take parser vsechny prikazy, vyrazy pritrazeni identifikuje jako novou deklaraci, protoze se vlastne prirazeni od deklarace v nasem
skriptovacim jazyce vubec nelisi. Proto vsechny deklarace, ktere obsahuji vlevo , tj. lvalue, jiz deklarovanou promennou, prevedeme
na prikazy prirazeni. Pri kontrole vyrazu jako +=, -= muzeme take narazit na lvalue, tj. promenne ktere este deklarovane nebyly. Musime tedy
zajistit jejich deklaraci, a tu vlozime pred prikaz, vyraz, kde se vyskytuji. To mame zajistenou automatickou deklaraci promennych.
Dale take nas jazyk podporuje automatickou inicializaci. Inicilializace promenne pri jeji deklaraci vyzadovana neni. Pokud tedy narazime
na deklaraci promenne bez inicializace, inicializujeme ji na nula. Dale najdeme duplicitni deklarace promennych. Ty se mohou vyskytnout
v deklaraci parametru funkce nebo v inicializaci for cyklu. Jinde to prakticky neni mozne, ostatni dekllarace jsou deklarace promennych a duplicitni vyskyt
je jak jsem jiz psal nahrazen prirazenim. V druhem pruchodu skriptem se kontroluji jmena funkci, zda jsou vsechny definovany. Tim ze strom prochazime
2x mame moznost definovat funkce az po jejich pouziti ve skriptu, coz treba C++ neumoznuje. Tam musi byt vzdy deklarace funkce predtim nez ji nekde pouzijeme, nebo aspon
musi byt deklarovan prototyp funkce.
*/
class CSymbolChecking
{
private:
	/*prvni pruchod*/
	void			process1PassSCRIPT(SCRIPT* theScript);
	void			process1PassTOPLEVEL(TOPLEVEL* toplevel, CHashedSymbolTable* symbolTable);
	void			process1PassFUNCTION(FUNCTION* functio, CHashedSymbolTable* symbolTable);
	void			process1PassDECLARATION(DECLARATION* declaration, CHashedSymbolTable* symbolTable);
	void			process1PassFORINIT(FORINIT* forinit, CHashedSymbolTable* symbolTable);
	void			process1PassSTATEMENT(STATEMENT* statement, CHashedSymbolTable* symbolTable);
	void			process1PassEXPRESSION(EXPRESSION* expression, CHashedSymbolTable* symbolTable);
	void			process1PassLVALUE(LVALUE* lvalue, CHashedSymbolTable* symbolTable);

	/*druhy pruchod*/
	void			process2PassSCRIPT(SCRIPT* theScript);
	void			process2PassTOPLEVEL(TOPLEVEL* toplevel, CHashedSymbolTable* symbolTable);
	void			process2PassFUNCTION(FUNCTION* function);
	void			process2PassDECLARATION(DECLARATION* declaration, CHashedSymbolTable* symbolTable);
	void			process2PassFORINIT(FORINIT* forinit, CHashedSymbolTable* symbolTable);
	void			process2PassSTATEMENT(STATEMENT* statement, CHashedSymbolTable* symbolTable);
	void			process2PassEXPRESSION(EXPRESSION* expression, CHashedSymbolTable* symbolTable);
public:
	//zpracovani skriptu
	void			Process(SCRIPT*	theScript);
};
